

<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Cart view')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
 <?php if($carts->count()>0): ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Cart view')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Cart view')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        CART VIEW START
    ==============================-->
    <section class="wsus__cart_view pt_120 xs_pt_80 pb_120 xs_pb_80">
        <div class="container">
            <div class="wsus__cart_area">
                <div class="row">
                    <div class="col-12">
                        <div class="wsus__cart_table">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th class="img"><?php echo e(__('user.Product')); ?></th>
                                            <th class="description"></th>
                                            <th class="price"><?php echo e(__('user.Price')); ?></th>
                                            <th class="discount"><?php echo e(__('user.Category')); ?></th>
                                            <th class="action"><?php echo e(__('user.Action')); ?></th>
                                        </tr>
                                    </thead>
                                    <tbody id="cartItem">

                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="row justify-content-between mt_80">
                    <div class="col-xxl-5 col-xl-6 col-lg-6">
                        <form class="wsus__cart_coupone">
                            <input type="text" id="coupon_name" placeholder="<?php echo e(__('user.Discount Code')); ?>">
                            <input type="hidden" id="coupon_valid" value="<?php echo e(__('user.Coupon is required')); ?>">
                            <button class="common_btn" onclick="couponApply()" type="button"><?php echo e(__('user.Apply')); ?></button>
                        </form>
                    </div>
                    <div class="col-xxl-4 col-xl-5 col-lg-5">
                        <div class="wsus__cart_price_list">
                            <ul class="d-flex flex-wrap justify-content-end">
                                <li><a class="common_btn" href="<?php echo e(route('products')); ?>"><?php echo e(__('user.Continue Shopping')); ?></a></li>
                            </ul>
                            <div class="list_item" id="calprice">

                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        CART VIEW END
    ==============================-->


    <!--=============================
        RELATED PRODUCT START
    ==============================-->
    <?php if($related_products->count() > 0): ?>
    <section class="wsus__related_product wsus__galley_2 pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e(__('user.Save time with pre-installed software')); ?>.</h5>
                        <h2><?php echo e(__('user.Related Products')); ?>.</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <?php
                                $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                            ?>

                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>

                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>

                            <p class="rating">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                            </p>
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>

                            <div class="like_and_sell">
                                <span class="download"><i class="fas fa-arrow-to-bottom"></i><?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <div class="col-12 text-center mt-5">
                    <h2 class="mt-5 text-danger"><?php echo e(__('user.Product Not Found')); ?></h2>
                </div>
                <?php endif; ?>
            </div>
            <a href="<?php echo e(route('products')); ?>" class="common_btn"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
        </div>
    </section>
    <?php endif; ?>
    <!--=============================
        RELATED PRODUCT END
    ==============================-->
 <?php else: ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Empty Cart')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Empty Cart')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        CART EMPTY START
    ==============================-->
    <section class="wsus__cart_empty pt_120 xs_pt_80 pb_110 xs_pb_70">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-md-7 m-auto">
                    <div class="wsus__cart_empty_text">
                        <div class="img">
                            <img src="<?php echo e(asset('frontend/images/empty_cart_img.png')); ?>" alt="empty cart" class="img-fluid w-100">
                        </div>
                        <h3><?php echo e(__('user.Your cart is empty')); ?></h3>
                        <a class="common_btn" href="<?php echo e(route('products')); ?>"><?php echo e(__('user.Continue To Shoping')); ?></a>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        CART EMPTY END
    ==============================-->
 <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/cart_view.blade.php ENDPATH**/ ?>