


<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo e($seo_setting->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Contact Us')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.Home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Contact Us')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        CONTACT US START
    ==============================-->
    <section class="wsus__contact_us pt_95 xs_pt_55">
        <div class="container">
            <div class="row">
                <div class="col-xl-4 col-md-6 col-lg-4">
                    <div class="wsus__contact_single_info">
                        <span><i class="fas fa-phone-alt"></i></span>
                        <a><?php echo nl2br($contact->contactlangfrontend->phone); ?></a>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-lg-4">
                    <div class="wsus__contact_single_info">
                        <span><i class="fas fa-envelope"></i></span>
                        <a><?php echo nl2br($contact->email); ?></a>
                    </div>
                </div>
                <div class="col-xl-4 col-md-6 col-lg-4">
                    <div class="wsus__contact_single_info">
                        <span><i class="fas fa-map-marker-alt"></i></span>
                        <a><?php echo nl2br($contact->contactlangfrontend->address); ?></a>
                    </div>
                </div>
            </div>
            <div class="row mt_120 xs_mt_80">
                <div class="col-xl-8 col-lg-7">
                    <form action="<?php echo e(route('send-contact-message')); ?>" method="POST" class="wsus__contact_form wsus__comment_input_area">
                        <?php echo csrf_field(); ?>
                        <h3><?php echo e($contact->contactlangfrontend->title1); ?></h3>
                        <div class="row">
                            <div class="col-xl-6">
                                <div class="wsus__comment_single_input">
                                    <fieldset>
                                        <legend><?php echo e(__('user.Name')); ?>*</legend>
                                        <input type="text" name="name" value="<?php echo e(old('name')); ?>" placeholder="<?php echo e(__('user.Name')); ?>">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="wsus__comment_single_input">
                                    <fieldset>
                                        <legend><?php echo e(__('user.Phone')); ?></legend>
                                        <input type="text" name="phone" value="<?php echo e(old('phone')); ?>" placeholder="<?php echo e(__('user.Phone')); ?>">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="wsus__comment_single_input">
                                    <fieldset>
                                        <legend><?php echo e(__('user.Email')); ?>*</legend>
                                        <input type="email" name="email" value="<?php echo e(old('email')); ?>" placeholder="<?php echo e(__('user.Email')); ?>">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-xl-6">
                                <div class="wsus__comment_single_input">
                                    <fieldset>
                                        <legend><?php echo e(__('user.Subject')); ?>*</legend>
                                        <input type="text" name="subject" value="<?php echo e(old('subject')); ?>" placeholder="<?php echo e(__('user.Subject')); ?>">
                                    </fieldset>
                                </div>
                            </div>
                            <div class="col-xl-12">
                                <div class="wsus__comment_single_input">
                                    <fieldset>
                                        <legend><?php echo e(__('user.Message')); ?>*</legend>
                                        <textarea rows="6" name="message" placeholder="<?php echo e(__('user.Write a Message')); ?>"><?php echo e(old('message')); ?></textarea>
                                    </fieldset>
                                </div>
                            </div>

                            <?php if($recaptchaSetting->status==1): ?>
                                <div class="col-xl-12">
                                    <div class="wsus__comment_single_input">
                                        <div class="g-recaptcha" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                    </div>
                                </div>
                            <?php endif; ?>

                            <div class="col-xl-12">
                                <button class="common_btn" type="submit"><?php echo e(__('user.Send Message')); ?></button>
                            </div>
                        </div>
                    </form>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="wsus__contact_support">
                        <div class="text">
                            <span class="icon"><i class="far fa-headset"></i></span>
                            <p>
                                <?php echo e($contact->contactlangfrontend->title2); ?>

                                <span><?php echo e($contact->contactlangfrontend->time); ?></span>
                                <?php echo e($contact->contactlangfrontend->off_day); ?>

                            </p>
                        </div>
                        <div class="img">
                            <img src="<?php echo e(custom_asset($contact->supporter_image)); ?>" alt="support classimg-fluid w-100">
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <div class="col-xl-12 pt_120 xs_pt_80">
            <div class="wsus__contact_map">
                <?php echo $contact->map; ?>

            </div>
        </div>
    </section>
    <!--=============================
        CONTACT US END
    ==============================-->
<?php $__env->stopSection(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/contact_us.blade.php ENDPATH**/ ?>