
<?php $__env->startSection('title'); ?>
<title><?php echo e(__('admin.Footer')); ?></title>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('admin-content'); ?>
      <!-- Main Content -->
      <div class="main-content">
        <section class="section">
          <div class="section-header">
            <h1><?php echo e(__('admin.Footer')); ?></h1>
            <div class="section-header-breadcrumb">
              <div class="breadcrumb-item active"><a href="<?php echo e(route('admin.dashboard')); ?>"><?php echo e(__('admin.Dashboard')); ?></a></div>
              <div class="breadcrumb-item"><?php echo e(__('admin.Footer')); ?></div>
            </div>
          </div>

          <div class="section-body">
            <div class="row mt-4">
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                      <h3 class="h3 mb-3 text-gray-800"><?php echo e(__('admin.Language')); ?></h3>
                      <hr>
                      <div class="lang_list_top">
                          <ul class="lang_list">
                              <?php $__currentLoopData = $languages; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $language): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                              <li><a href="<?php echo e(route('admin.footer.index', ['lang_code' => $language->lang_code])); ?>"><i class="fas fa-edit"></i> <?php echo e($language->lang_name); ?></a></li>
                              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </ul>
                      </div>

                      <div class="alert alert-danger mt-2" role="alert">
                          <?php
                              $current_language = App\Models\Language::where('lang_code', request()->get('lang_code'))->first();
                          ?>
                          <p><?php echo e(__('admin.Your editing mode')); ?> : <b><?php echo e($current_language->lang_name); ?></b></p>
                      </div>
                    </div>
                  </div>
              </div>
                <div class="col-12">
                  <div class="card">
                    <div class="card-body">
                        <form action="<?php echo e(route('admin.footer.update', $footer->id)); ?>" method="POST" enctype="multipart/form-data">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('PUT'); ?>
                            <input type="hidden" name="lang_code" value="<?php echo e(request()->get('lang_code')); ?>">

                            <div class="row">
                              <?php if(session()->get('admin_lang') == request()->get('lang_code')): ?>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Existing Image')); ?></label>
                                    <div>
                                        <img src="<?php echo e(custom_asset($footer->payment_image)); ?>" alt="" width="220px">
                                    </div>
                                </div>
                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Payment Card Image')); ?></label>
                                    <input type="file" name="card_image" class="form-control-file" >
                                </div>
                              <?php endif; ?>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Copyright')); ?> <span class="text-danger">*</span></label>
                                    <input type="text" name="copyright" class="form-control" value="<?php echo e($footer_language->copyright); ?>">
                                </div>

                                <div class="form-group col-12">
                                    <label><?php echo e(__('admin.Description')); ?> <span class="text-danger">*</span></label>
                                    <textarea class="form-control text-area-5" name="description" id="" cols="30" rows="5"><?php echo e($footer_language->description); ?></textarea>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-12">
                                    <button class="btn btn-primary"><?php echo e(__('admin.Update')); ?></button>
                                </div>
                            </div>
                        </form>
                    </div>
                  </div>
                </div>
          </div>
        </section>
      </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('admin.master_layout', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/admin/website_footer.blade.php ENDPATH**/ ?>