
<?php $__env->startSection('title'); ?>
    <title><?php echo e(__('user.Register')); ?></title>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.sign up')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.sign up')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        SIGN UP START
    ==============================-->
    <section class="wsus__sign_up mt_120 xs_mt_80 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-9 m-auto">
                    <div class="wsus__signup_text">
                        <h3><?php echo e(__('user.Register')); ?></h3>
                        <p class="description"><?php echo e(__('user.Welcome to Alasmart')); ?>.</p>
                        <form action="<?php echo e(route('store-register')); ?>" method="POST">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-lg-12">
                                    <div class="wsus__comment_single_input">
                                        <fieldset>
                                            <legend><?php echo e(__('user.Name')); ?>*</legend>
                                            <input type="text" name="name" placeholder="<?php echo e(__('user.Name')); ?>">
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="wsus__comment_single_input">
                                        <fieldset>
                                            <legend><?php echo e(__('user.Email')); ?>*</legend>
                                            <input type="email" name="email" placeholder="<?php echo e(__('user.Email')); ?>">
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="wsus__comment_single_input">
                                        <fieldset>
                                            <legend><?php echo e(__('user.Password')); ?>*</legend>
                                            <input type="password" id="passowrd_input" name="password" placeholder="<?php echo e(__('user.Password')); ?>">
                                            <span id="show_password"><i class="fas fa-eye-slash"></i></span>
                                        </fieldset>
                                    </div>
                                </div>
                                <div class="col-12">
                                    <div class="wsus__comment_single_input">
                                        <fieldset>
                                            <legend><?php echo e(__('user.Confirm Password')); ?>*</legend>
                                            <input type="password" name="c_password" id="c_passowrd_input" placeholder="<?php echo e(__('user.Confirm Password')); ?>">
                                            <span id="c_show_password"><i class="fas fa-eye-slash"></i></span>
                                        </fieldset>
                                    </div>
                                </div>
                                <?php if($recaptchaSetting->status==1): ?>
                                    <div class="col-xl-12">
                                        <div class="wsus__single_com">
                                            <div class="g-recaptcha" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                                <div class="col-12 mt-4">
                                    <button type="submit" class="common_btn"><?php echo e(__('user.Registration')); ?></button>
                                </div>
                            </div>
                        </form>
                        <p class="other_login"><?php echo e(__('user.Already have an Account')); ?>? <a href="<?php echo e(route('login')); ?>"><?php echo e(__('user.Log In')); ?></a></p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        SIGN UP END
    ==============================-->
<?php $__env->stopSection(); ?>

<?php $__env->startPush('frontend_js'); ?>
<script>
    "use strict";
    let password_show = false;
    let c_password_show = false;
    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#show_password").on("click", function(){
                password_show = !password_show;
                if(password_show){
                    $(this).html('<i class="fas fa-eye"></i>')

                    $('#passowrd_input').prop('type', 'text');

                }else{
                    $(this).html('<i class="fas fa-eye-slash"></i>')
                    $('#passowrd_input').prop('type', 'password');
                }
            });

            $("#c_show_password").on("click", function(){
                c_password_show = !c_password_show;
                if(c_password_show){
                    $(this).html('<i class="fas fa-eye"></i>')

                    $('#c_passowrd_input').prop('type', 'text');

                }else{
                    $(this).html('<i class="fas fa-eye-slash"></i>')
                    $('#c_passowrd_input').prop('type', 'password');
                }
            })
        });
    })(jQuery);
</script>
<?php $__env->stopPush(); ?>
<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/register.blade.php ENDPATH**/ ?>