

<?php $__env->startSection('title'); ?>
    <title><?php echo e($product->productlangfrontend->name); ?></title>
    <meta name="title" content="<?php echo e($product->productlangfrontend->seo_title); ?>">
    <meta name="description" content="<?php echo e($product->productlangfrontend->seo_description); ?>">
<?php $__env->stopSection(); ?>

<?php $__env->startSection('frontend-content'); ?>
    <!--=============================
        BREADCRUMB START
    ==============================-->
    <section class="wsus__breadcrumb" style="background: url(<?php echo e(asset('frontend/images/breadcrumb_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-12">
                    <div class="wsus__breadcrumb_text">
                        <h1><?php echo e(__('user.Our Products')); ?></h1>
                        <ul class="d-flex flex-wrap">
                            <li><a href="<?php echo e(route('home')); ?>"><?php echo e(__('user.home')); ?></a></li>
                            <li><a href="javascript:;"><?php echo e(__('user.Our Products')); ?></a></li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BREADCRUMB END
    ==============================-->


    <!--=============================
        PRODUCT DETAILS START
    ==============================-->
    <section class="wsus__product_details pt_120 xs_pt_80 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-8 col-lg-7 ">
                    <div class="wsus__product_details_img">
                        <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="product" class="img-fluod w-100">
                    </div>

                    <div class="wsus__product_details_text">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home"
                                    aria-selected="true"><i class="fal fa-layer-group"></i> <?php echo e(__('user.Description')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-profile" type="button" role="tab"
                                    aria-controls="pills-profile" aria-selected="false"><i class="far fa-comments"></i>
                                    <?php echo e(__('user.Comments')); ?> (<?php echo e($productComments->count()); ?>)</button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-contact" type="button" role="tab"
                                    aria-controls="pills-contact" aria-selected="false"><i class="far fa-star"></i>
                                    <?php echo e(__('user.Review')); ?> (<?php echo e($productReviews->count()); ?>)</button>
                            </li>

                            <li class="nav-item" role="presentation">
                                <button onclick="addWishlist(<?php echo e($product->id); ?>)"><i class="far fa-heart" aria-hidden="true"></i>
                                    <?php echo e(__('user.Wishlist')); ?></button>
                            </li>

                        </ul>
                        <div class="tab-content" id="pills-tabContent">
                            <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                                aria-labelledby="pills-home-tab" tabindex="0">
                                <div class="wsus__pro_description">
                                    <?php echo clean(html_decode($product->productlangfrontend->description)); ?>

                                </div>
                            </div>
                            <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                                aria-labelledby="pills-profile-tab" tabindex="0">
                                <div class="wsus__pro_det_comment">
                                    <h4><?php echo e(__('user.Comments')); ?></h4>
                                    <?php $__currentLoopData = $productComments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productComment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="wsus__single_comment">
                                        <div class="comment_footer d-flex flex-wrap">
                                            <div class="img">
                                                <?php if($productComment->user->image!=null): ?>
                                                <img src="<?php echo e(custom_asset($productComment->user->image)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php elseif($productComment->user->provider=='google'): ?>
                                                <img src="<?php echo e(custom_asset($productComment->user->provider_avatar)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php else: ?>
                                                <img src="<?php echo e(custom_asset($setting->default_avatar)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php endif; ?>
                                            </div>
                                            <div class="text">
                                                <h3><?php echo e(html_decode($productComment->name)); ?></h3>
                                                <p><?php echo e(html_decode($productComment->address)); ?></p>
                                            </div>
                                        </div>
                                        <p class="comment_des"><?php echo html_decode($productComment->comment); ?></p>
                                        <p class="comment_date"> <span class="date"><i class="far fa-calendar-alt"></i>
                                            <?php echo e(Carbon\Carbon::parse($productComment->created_at)->format('F d,Y')); ?> <?php echo e(__('user.At')); ?>

                                            <?php echo e(Carbon\Carbon::parse($productComment->created_at)->format('h:ia')); ?> </span>
                                        </p>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>
                                <div class="wsus__pagination">
                                    <?php if($productComments->hasPages()): ?>
                                        <div class="row">
                                            <?php echo e($productComments->links('custom_pagination')); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                                <form class="wsus__comment_input_area" id="productCommentForm" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <h3><?php echo e(__('user.Leave a Comment')); ?></h3>
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="wsus__comment_single_input">
                                                <fieldset>
                                                    <legend><?php echo e(__('user.Comment')); ?>*</legend>
                                                    <textarea rows="7" name="comment" placeholder="<?php echo e(__('user.Type here')); ?>.."></textarea>
                                                    <input type="hidden" name="product_id" value="<?php echo e($product->id); ?>">
                                                </fieldset>
                                            </div>
                                            <?php if($recaptchaSetting->status==1): ?>
                                            <div class="wsus__comment_single_input">
                                                <div class="g-recaptcha mt-2" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                            </div>
                                            <?php endif; ?>
                                            <button class="common_btn" id="submitBtn" type="submit"><?php echo e(__('user.Submit Comment')); ?></button>
                                            <button class="common_btn d-none" id="showSpain" type="submit"><i class="fas fa-spinner fa-spin"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                            <div class="tab-pane fade" id="pills-contact" role="tabpanel"
                                aria-labelledby="pills-contact-tab" tabindex="0">
                                <div class="wsus__pro_det_review">
                                    <h3><?php echo e(__('user.Reviews')); ?></h3>
                                    <?php $__currentLoopData = $productReviews; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $productReview): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <div class="wsus__single_comment">
                                        <div class="comment_footer d-flex flex-wrap">
                                            <div class="img">
                                                <?php if($productReview->user->image!=null): ?>
                                                <img src="<?php echo e(custom_asset($productReview->user->image)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php elseif($productReview->user->provider=='google'): ?>
                                                <img src="<?php echo e(custom_asset($productReview->user->provider_avatar)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php else: ?>
                                                <img src="<?php echo e(custom_asset($setting->default_avatar)); ?>" alt="useer" class="img-fluid w-100">
                                                <?php endif; ?>
                                            </div>
                                            <div class="text">
                                                <h3><?php echo e(html_decode($productReview->user->name)); ?>

                                                    <span>
                                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                                            <?php if($i <= $productReview->rating): ?>
                                                            <i class="fas fa-star"></i>
                                                            <?php else: ?>
                                                            <i class="far fa-star"></i>
                                                            <?php endif; ?>
                                                        <?php endfor; ?>
                                                    </span>
                                                </h3>
                                                <p><?php echo e(html_decode($productReview->user->address)); ?></p>
                                            </div>
                                        </div>
                                        <p class="comment_des"><?php echo e(html_decode($productReview->review)); ?></p>
                                        <p class="comment_date"> <span class="date"><i class="far fa-calendar-alt"></i>
                                            <?php echo e(Carbon\Carbon::parse($productReview->created_at)->format('F d,Y')); ?> <?php echo e(__('user.At')); ?> <?php echo e(Carbon\Carbon::parse($productReview->created_at)->format('h:ia')); ?> </span>
                                        </p>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <div class="wsus__pagination">
                                    <?php if($productReviews->hasPages()): ?>
                                        <div class="row">
                                            <?php echo e($productReviews->links('custom_pagination')); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>

                                <form class="wsus__comment_input_area" id="productReviewForm" method="POST">
                                    <?php echo csrf_field(); ?>
                                    <h3><?php echo e(__('user.Write Your Reviews')); ?></h3>
                                    <p>
                                        <i class="fas fa-star s1"></i>
                                        <i class="fas fa-star s2"></i>
                                        <i class="fas fa-star s3"></i>
                                        <i class="fas fa-star s4"></i>
                                        <i class="fas fa-star s5"></i>
                                        <span class="total_star">(0.0)</span>
                                    </p>
                                    <div class="row">
                                        <div class="col-xl-12">
                                            <div class="wsus__comment_single_input">
                                                <fieldset>
                                                    <legend><?php echo e(__('user.comment')); ?>*</legend>
                                                    <textarea rows="7" name="review" placeholder="<?php echo e(__('user.Type here')); ?>.."></textarea>
                                                    <input type="hidden" class="star" name="rating" value="">
                                                    <input type="hidden" id="product_id" name="product_id" value="<?php echo e($product->id); ?>">
                                                    <input type="hidden" id="author_id" name="author_id" value="<?php echo e($product->author->id); ?>">
                                                </fieldset>
                                            </div>

                                            <?php if($recaptchaSetting->status==1): ?>
                                            <div class="wsus__comment_single_input">
                                                <div class="g-recaptcha mt-2" data-sitekey="<?php echo e($recaptchaSetting->site_key); ?>"></div>
                                            </div>
                                            <?php endif; ?>

                                            <button class="common_btn" id="reviewSubmitBtn" type="submit"><?php echo e(__('user.Submit Review')); ?></button>
                                            <button class="common_btn d-none" id="reviewShowSpain" type="submit"><i class="fas fa-spinner fa-spin"></i></button>
                                        </div>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-4 col-lg-5">
                    <div class="wsus__sidebar pl_30 xs_pl_0" id="sticky_sidebar">
                        <div class="wsus__sidebar_licence">
                            <?php if($product->product_type != 'script'): ?>
                                <?php if($variants->count() > 0): ?>
                                <div class="select_licance">
                                    <select class="select_js" name="variant_id" id="variant_id">
                                        <?php $__currentLoopData = $variants; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $variant): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($variant->id); ?>"><?php echo e(html_decode($variant->variant_name)); ?></option>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </select>
                                </div>
                                <h2>
                                    <?php if(session()->get('currency_position') == 'right'): ?>
                                        <strong id="price"><?php echo e(html_decode($first_variant->price * session()->get('currency_rate'))); ?></strong><span class="right_currency_icon"><?php echo e(session()->get('currency_icon')); ?></span>
                                    <?php else: ?>
                                        <span><?php echo e(session()->get('currency_icon')); ?></span> <strong id="price"><?php echo e(html_decode($first_variant->price * session()->get('currency_rate'))); ?></strong>
                                    <?php endif; ?>
                                </h2>
                                <input type="hidden" value="<?php echo e(session()->get('currency_rate')); ?>" id="currency_rate">
                                <input type="hidden" value="<?php echo e($first_variant->price); ?>" id="image_price">
                                <?php endif; ?>
                            <?php endif; ?>
                            <?php if($product->product_type == 'script'): ?>
                            <div class="select_licance">
                                <select class="select_js" name="price_type" id="price_type">
                                    <option value="regular price"><?php echo e(__('user.Regular Price')); ?></option>
                                    <option value="extend price"><?php echo e(__('user.extend Price')); ?></option>
                                </select>
                            </div>

                            <?php if(session()->get('currency_position') == 'right'): ?>
                                <h2 class="" id="reg_price"><strong id="regular_price"><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?></strong> <span class="right_currency_icon"><?php echo e(session()->get('currency_icon')); ?></span></h2>

                                <h2 class="d-none" id="ext_price"><strong id="extend_price"><?php echo e(html_decode($product->extend_price * session()->get('currency_rate'))); ?></strong> <span class="right_currency_icon"><?php echo e(session()->get('currency_icon')); ?></span> </h2>
                            <?php else: ?>
                                <h2 class="" id="reg_price"><span><?php echo e(session()->get('currency_icon')); ?></span> <strong id="regular_price"><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?></strong></h2>

                                <h2 class="d-none" id="ext_price"><span><?php echo e(session()->get('currency_icon')); ?></span> <strong id="extend_price"><?php echo e(html_decode($product->extend_price * session()->get('currency_rate'))); ?></strong></h2>
                            <?php endif; ?>

                            <ul class="feature" id="regular_content">
                                <?php echo $script_content->scriptlangfrontend->regular_content; ?>

                            </ul>
                            <ul class="feature d-none" id="extend_content">
                                <?php echo $script_content->scriptlangfrontend->extend_content; ?>

                            </ul>
                            <?php endif; ?>

                            <input type="hidden" value="<?php echo e($product->regular_price); ?>" id="script_regular_price">
                            <input type="hidden" value="<?php echo e($product->extend_price); ?>" id="script_extend_price">
                            <input type="hidden" value="<?php echo e($product->product_type); ?>" id="product_type">
                            <input type="hidden" value="<?php echo e($product->productlangfrontend->name); ?>" id="product_name">
                            <input type="hidden" value="<?php echo e($product->slug); ?>" id="slug">
                            <input type="hidden" value="<?php echo e($product->category->catlangfrontend->name); ?>" id="category_name">
                            <input type="hidden" value="<?php echo e($product->category->id); ?>" id="category_id">
                            <input type="hidden" value="<?php echo e($product->thumbnail_image); ?>" id="product_image">
                            <input type="hidden" value="<?php echo e($product->author->name); ?>" id="author_name">
                            <input type="hidden" value="<?php echo e($product->author->id); ?>" id="author_id">
                            <ul class="button_area mt_50 d-flex flex-wrap <?php echo e($product->product_type=='script' ? '':'mt-3'); ?>">
                                <li><a class="live" target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Live Preview')); ?></a></li>
                                <li><a class="common_btn" href="javascript:;" onclick="addToCard(<?php echo e($product->id); ?>)"><?php echo e(__('user.add to cart')); ?></a></li>
                            </ul>
                            <ul class="sell_rating mt_20 d-flex flex-wrap justify-content-between">
                                <li><i class="far fa-cart-arrow-down"></i> <?php echo e($total_sale); ?></li>
                                <li><i class="far fa-comments"></i> <?php echo e($productComments->count()); ?></li>
                                <li><i class="far fa-star"></i> <?php echo e($productReviews->count()); ?></li>
                            </ul>
                        </div>

                        <div class="wsus__sidebar_author_info mt_30">
                            <h3><?php echo e(__('user.Author Profile')); ?></h3>
                            <div class="wsus__sidebar_author_text">
                                <div class="img">
                                    <?php if($product->author->image!=null): ?>
                                    <img src="<?php echo e(custom_asset($product->author->image)); ?>" alt="author" class="img-fluid w-100">
                                    <?php elseif($product->author->provider=='google'): ?>
                                    <img src="<?php echo e(custom_asset($product->author->provider_avatar)); ?>" alt="author" class="img-fluid w-100">
                                    <?php else: ?>
                                    <img src="<?php echo e(custom_asset($setting->default_avatar)); ?>" alt="author" class="img-fluid w-100">
                                    <?php endif; ?>
                                </div>
                                <div class="text">
                                    <h4><?php echo e(html_decode($product->author->name)); ?></h4>
                                    <p><?php echo e(__('user.Joined')); ?> - <?php echo e(Carbon\Carbon::parse($product->author->created_at)->format('F Y')); ?></p>
                                </div>
                            </div>
                            <ul class="d-flex flex-wrap justify-content-center">
                                <?php
                                    $total_sold=App\Models\OrderItem::where('author_id', $product->author->id)->get()->count();
                                    $total_product=App\Models\Product::where(['author_id' => $product->author->id, 'status' => 1])->get()->count();
                                ?>
                                <li>
                                    <h4><?php echo e($total_product); ?></h4>
                                    <p><?php echo e(__('user.products')); ?></p>
                                </li>
                                <li>
                                    <h4><?php echo e($total_sold); ?></h4>
                                    <p><?php echo e(__('user.Total sale')); ?></p>
                                </li>
                            </ul>
                            <a class="common_btn w-100" href="<?php echo e(route('author-profile', $product->author->user_name )); ?>"><i class="fal fa-stars"></i> <?php echo e(__('user.View Profile')); ?></a>
                        </div>

                        <div class="wsus__sidebar_pro_info mt_30">
                            <h3><?php echo e(__('user.product Info')); ?></h3>
                            <ul>
                                <li><span><?php echo e(__('user.Released')); ?></span> <?php echo e(Carbon\Carbon::parse($product->created_at)->format('F d,Y')); ?></li>
                                <li><span><?php echo e(__('user.Updated')); ?></span> <?php echo e(Carbon\Carbon::parse($product->updated_at)->format('F d,Y')); ?></li>
                                <li><span><?php echo e(__('user.File Type')); ?></span> <?php echo e($product->product_type); ?></li>
                                <li><span><?php echo e(__('user.High Resolution')); ?></span> <?php echo e($product->high_resolution == 1 ? 'Yes' : 'No'); ?></li>
                                <li><span><?php echo e(__('user.Cross browser')); ?></span> <?php echo e($product->cross_browser == 1 ? 'Yes' : 'No'); ?></li>
                                <li><span><?php echo e(__('user.Documentation')); ?></span> <?php echo e($product->documentation == 1 ? 'Yes' : 'No'); ?></li>
                                <li><span><?php echo e(__('user.Responsive')); ?></span> <?php echo e($product->layout == 1 ? 'Yes' : 'No'); ?></li>
                                <li><span><?php echo e(__('user.Tags')); ?></span>
                                    <?php
                                        $tag_arr=[];
                                        $tags=explode(',', $product->productlangfrontend->tags);
                                        foreach($tags as $tag){
                                            $tag_arr[]=$tag;
                                        }
                                        array_pop($tag_arr);
                                    ?>
                                    <p>
                                        <?php $__currentLoopData = $tag_arr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $tag): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <a href="<?php echo e(route('products', ['keyword' => strtolower($tag)])); ?>"><?php echo e(html_decode($tag)); ?>,</a>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    </p>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        PRODUCT DETAILS END
    ==============================-->


    <!--=============================
        RELATED PRODUCT START
    ==============================-->
    <?php if($related_products->count() > 0): ?>
    <section class="wsus__related_product wsus__galley_2 pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e(__('user.Save time with pre-installed software')); ?>.</h5>
                        <h2><?php echo e(__('user.Related Products')); ?>.</h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $related_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <?php
                                $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                            ?>

                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>

                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>

                            <p class="rating">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                            </p>
                            <p class="price"><?php echo e($setting->currency_icon); ?><?php echo e(html_decode($product->regular_price)); ?></p>

                            <div class="like_and_sell">
                                <span class="download"><i class="fas fa-arrow-to-bottom"></i><?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <a href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>" class="common_btn"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
        </div>
    </section>
    <?php endif; ?>
    <!--=============================
        RELATED PRODUCT END
    ==============================-->
<?php $__env->stopSection(); ?>
<?php $__env->startPush('frontend_js'); ?>
<script>
    (function($) {
        "use strict";
        $(document).ready(function () {
            $("#contactWithAuthor").on("submit", function(e){
                e.preventDefault();

                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                 $('#submitBtnn').addClass('d-none');
                 $('#showSpainn').removeClass('d-none');
                $.ajax({
                    url: "<?php echo e(route('contact-with-author')); ?>",
                    type:"post",
                    data:$('#contactWithAuthor').serialize(),
                    success:function(response){
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#contactWithAuthor").trigger("reset");
                            $('#submitBtnn').removeClass('d-none');
                            $('#showSpainn').addClass('d-none');
                            $('#cancelBtn').click();
                        }

                        if(response.status == 0){
                            toastr.error(response.message)
                            $("#contactWithAuthor").trigger("reset");
                            $('#submitBtnn').removeClass('d-none');
                            $('#showSpainn').addClass('d-none');
                        }
                    },
                    error:function(response){
                        if(response.status == 403){
                            toastr.error(response.responseJSON.message);
                            $('#submitBtnn').removeClass('d-none');
                            $('#showSpainn').addClass('d-none');
                        }else{
                            if(response.responseJSON.errors.message)toastr.error(response.responseJSON.errors.message[0])
                            $('#submitBtnn').removeClass('d-none');
                            $('#showSpainn').addClass('d-none');
                            if(!response.responseJSON.errors.message){
                                toastr.error("<?php echo e(__('user.Please complete the recaptcha to submit the form')); ?>")
                            }
                        }
                    }
                });
            });

            $("#productCommentForm").on('submit', function(e){
                e.preventDefault();
                $('#showSpain').removeClass('d-none');
                $('#submitBtn').addClass('d-none');
                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                $.ajax({
                    type: 'POST',
                    data: $('#productCommentForm').serialize(),
                    url: "<?php echo e(route('product-comment')); ?>",
                    success: function (response) {
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#productCommentForm").trigger("reset");
                            $('#showSpain').addClass('d-none');
                            $('#submitBtn').removeClass('d-none');
                        }
                        if(response.status == 0){
                            toastr.error(response.message);
                            $('#showSpain').addClass('d-none');
                            $('#submitBtn').removeClass('d-none');
                        }
                    },
                    error: function(response) {
                        $('#showSpain').addClass('d-none');
                        $('#submitBtn').removeClass('d-none');
                        if(response.responseJSON.errors.comment)toastr.error(response.responseJSON.errors.comment[0])
                        if(!response.responseJSON.errors.comment){
                            toastr.error("<?php echo e(__('user.Please complete the recaptcha to submit the form')); ?>")
                        }
                    }
                });
            });

            $("#productReviewForm").on('submit', function(e){
                e.preventDefault();
                $('#reviewShowSpain').removeClass('d-none');
                $('#reviewSubmitBtn').addClass('d-none');
                var isDemo = "<?php echo e(env('APP_MODE')); ?>"
                if(isDemo == 'DEMO'){
                    toastr.error('This Is Demo Version. You Can Not Change Anything');
                    return;
                }
                $.ajax({
                    type: 'POST',
                    data: $('#productReviewForm').serialize(),
                    url: "<?php echo e(route('product-review')); ?>",
                    success: function (response) {
                        if(response.status == 1){
                            toastr.success(response.message)
                            $("#productReviewForm").trigger("reset");
                            $('#reviewShowSpain').addClass('d-none');
                            $('#reviewSubmitBtn').removeClass('d-none');
                        }
                        if(response.status == 0){
                            toastr.error(response.message);
                            $('#reviewShowSpain').addClass('d-none');
                            $('#reviewSubmitBtn').removeClass('d-none');
                        }
                    },
                    error: function(response) {
                        $('#reviewShowSpain').addClass('d-none');
                        $('#reviewSubmitBtn').removeClass('d-none');
                        if(response.responseJSON.errors.rating)toastr.error(response.responseJSON.errors.rating[0])
                        if(response.responseJSON.errors.review)toastr.error(response.responseJSON.errors.review[0])
                        if(!response.responseJSON.errors.comment){
                            toastr.error("<?php echo e(__('user.Please complete the recaptcha to submit the form')); ?>")
                        }
                    }
                });
            });

           $('#send_message_btn').on('click', function(){
            toastr.error('Please login your account');
           });

            $("#variant_id").on("change", function(){
                let variant_id = $(this).val();

                $.ajax({
                    url: "<?php echo e(url('/variant-price')); ?>" + "/" + variant_id,
                    type:"get",
                    success:function(response){
                        if(response){
                            let variant_price= response.variant.price;
                            let currency_rate = $('#currency_rate').val();
                            $('#price').text(variant_price * currency_rate);
                            $('#image_price').val(variant_price);
                        }
                    }
                });

        });

        $("#price_type").on("change", function(){
                let price_type = $(this).val();
                if(price_type=='extend price'){
                    $('#reg_price').addClass('d-none');
                    $('#ext_price').removeClass('d-none');
                    $('#extend_content').removeClass('d-none');
                    $('#regular_content').addClass('d-none');
                }else if(price_type=='regular price'){
                    $('#reg_price').removeClass('d-none');
                    $('#ext_price').addClass('d-none');
                    $('#regular_content').removeClass('d-none');
                    $('#extend_content').addClass('d-none');
                }
        });
    });
})(jQuery);

</script>

<script>
    "use strict";
    $(document).ready(function(){
        $('.s1').on('click', function(){
            $('.s2, .s3, .s4, .s5').removeClass('fas fa-star text-warning');
            $('.s2, .s3, .s4, .s5').addClass('fas fa-star');
            $('.s1').removeClass('fas fa-star');
            $('.s1').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(1);
            $('.total_star').text('');
            $('.total_star').text('('+1+'.0)');
        });
        $('.s2').on('click', function(){
            $('.s3, .s4, .s5').removeClass('fas fa-star text-warning');
            $('.s3, .s4, .s5').addClass('fas fa-star');
            $('.s1, .s2').removeClass('fas fa-star');
            $('.s1, .s2').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(2);
            $('.total_star').text('');
            $('.total_star').text('('+2+'.0)');
        });
        $('.s3').on('click', function(){
            $('.s4, .s5').removeClass('fas fa-star text-warning');
            $('.s4, .s5').addClass('fas fa-star');
            $('.s1, .s2, .s3').removeClass('fas fa-star');
            $('.s1, .s2, .s3').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(3);
            $('.total_star').text('');
            $('.total_star').text('('+3+'.0)');
        });
        $('.s4').on('click', function(){
            $('.s5').removeClass('fas fa-star text-warning');
            $('.s5').addClass('fas fa-star ');
            $('.s1, .s2, .s3, .s4').removeClass('fas fa-star');
            $('.s1, .s2, .s3, .s4').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(4);
            $('.total_star').text('');
            $('.total_star').text('('+4+'.0)');
        });
        $('.s5').on('click', function(){
            $('.s1, .s2, .s3, .s4, .s5').removeClass('fas fa-star');
            $('.s1, .s2, .s3, .s4, .s5').addClass('fas fa-star text-warning');
            $('.star').val('');
            $('.star').val(5);
            $('.total_star').text('');
            $('.total_star').text('('+5+'.0)');
        });
    })
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make($active_theme, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/product_detail.blade.php ENDPATH**/ ?>