

<?php $__env->startSection('title'); ?>
    <title><?php echo e($seo_setting->seo_title); ?></title>
    <meta name="title" content="<?php echo e($seo_setting->seo_title); ?>">
    <meta name="description" content="<?php echo e($seo_setting->seo_description); ?>">
<?php $__env->stopSection(); ?>
<?php $__env->startSection('frontend-content'); ?>
    <?php if($intro_visibility): ?>
    <!--=============================
        BANNER START
    ==============================-->
    <section class="wsus__banner" style="background: url(<?php echo e(asset('frontend/images/banner_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xxl-6 col-sm-12 col-lg-7">
                    <div class="wsus__banner_text">
                        <h1><?php echo e($intro_section->content->sliderlangfrontend->home2_title); ?></h1>
                        <P><?php echo e($intro_section->content->sliderlangfrontend->home2_description); ?></P>
                        <form action="<?php echo e(route('products')); ?>" method="GET">
                            <select class="select_js" name="category">
                                <option value=""><?php echo e(__('user.All Categories')); ?></option>
                                <?php $__currentLoopData = $intro_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($category->slug); ?>"><?php echo e($category->catlangfrontend->name); ?></option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                            <input type="text" name="keyword" placeholder="<?php echo e(__('user.Search your products')); ?>...">
                            <button class="common_btn" type="submit"><i class="far fa-search"></i> <?php echo e(__('user.Search')); ?></button>
                        </form>
                        <ul class="wsus__banner_counter d-flex flex-wrap">
                            <li>
                                <span class="counter"><?php echo e($intro_section->content->total_user); ?></span>
                                <span><?php echo e(__('user.k')); ?>+</span>
                                <?php echo e(__('user.Users')); ?>

                            </li>
                            <li>
                                <span class="counter"><?php echo e($intro_section->content->total_sold); ?></span>
                                <span>+</span>
                                <?php echo e(__('user.Million Sells')); ?>

                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xxl-5 col-sm-12 col-lg-5">
                    <div class="wsus__banner_img">
                        <img src="<?php echo e(asset('frontend/images/banner_img.png')); ?>" alt="banner" class="img-fluid w-100">
                        <p>
                            <span><?php echo e($intro_section->content->total_product); ?><?php echo e(__('user.k')); ?>+</span>
                            <?php echo e(__('user.Prodcuts')); ?>

                        </p>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BANNER END
    ==============================-->
    <?php endif; ?>

    <?php if($category_visibility): ?>
    <!--=============================
        CATEGORIES START
    ==============================-->
    <section class="wsus__categories pb_175 xs_pb_0">
        <div class="container">
            <div class="wsus__categorie_area">
                <div class="row category_slider">
                    <?php $__currentLoopData = $category_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=>$category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="col-xl-3">
                        <div class="wsus__categories_item">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($category->icon)); ?>" alt="category" class="img-fluid w-100">
                            </div>
                            <h3><?php echo e($category->catlangfrontend->name); ?></h3>
                            <a class="view_all" href="<?php echo e(route('products', ['category' => $category->slug])); ?>"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        CATEGORIES END
    ==============================-->
    <?php endif; ?>


    <?php if($product_section->visibility): ?>
    <!--=============================
        GALLERY START
    ==============================-->
    <section class="wsus__galley pt_115 xs_pt_75">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-9 m-auto">
                    <div class="wsus__section_heading mb_35">
                        <h5><?php echo e($product_section->title); ?></h5>
                        <h2><?php echo e($product_section->description); ?></h2>
                    </div>
                </div>
            </div>

            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="gallery_filter d-flex flex-wrap mb_5">
                        <button class=" active" data-filter="*"><?php echo e(__('user.All Categories')); ?></button>
                        <?php $__currentLoopData = $product_section->categories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <button data-filter=".<?php echo e($category->id); ?>"><?php echo e($category->catlangfrontend->name); ?></button>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            </div>

            <div class="row grid">
                <?php $__currentLoopData = $product_section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6 <?php echo e($product->category->id); ?>">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="_blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>
                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>
                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>
                            <ul class="d-flex flex-wrap justify-content-between">
                                <?php
                                    $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                    $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                                ?>
                                <li>
                                    <p>
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($i <= $review): ?>
                                            <i class="fas fa-star"></i>
                                            <?php else: ?>
                                            <i class="far fa-star"></i>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                        <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                                    </p>
                                </li>
                                <li>
                                    <span class="download"><i class="far fa-download"></i> <?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                                </li>
                            </ul>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        GALLERY END
    ==============================-->
   <?php endif; ?>


   <?php if($counter_section->visibitliy): ?>
    <!--=============================
        COUNTER START
    ==============================-->
    <section class="wsus__counter mt_120 xs_mt_80" style="background: url(<?php echo e(custom_asset($counter_section->counter_home2_background)); ?>);">
        <div class="wsus__counter_overlay pt_90 pb_85 xs_pb_35">
            <div class="container">
                <div class="row">
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home2_icon1)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter1_value); ?></h2>
                            <p><?php echo e($counter_section->counter1_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home2_icon2)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter2_value); ?></h2>
                            <p><?php echo e($counter_section->counter2_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home2_icon3)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter3_value); ?></h2>
                            <p><?php echo e($counter_section->counter3_title); ?></p>
                        </div>
                    </div>
                    <div class="col-lg-3 col-sm-6">
                        <div class="wsus__single_counter">
                            <div class="icon">
                                <img src="<?php echo e(custom_asset($counter_section->home2_icon4)); ?>" alt="counter" class="img-fluid w-100">
                            </div>
                            <h2 class="counter"><?php echo e($counter_section->counter4_value); ?></h2>
                            <p><?php echo e($counter_section->counter4_title); ?></p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        COUNTER END
    ==============================-->
    <?php endif; ?>


    <?php if($popular_trending->visibility): ?>
    <!--=============================
        RECENT PRODUCT START
    ==============================-->
    <section class="wsus__recent_product wsus__recent_product_2  pt_115 xs_pt_75">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-6">
                    <div class="wsus__section_heading heading_left mb_5">
                        <h5><?php echo e($popular_trending->title); ?></h5>
                        <h2><?php echo e($popular_trending->description); ?></h2>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-6">
                    <div class="wsus__recent_product_filter d-flex flex-wrap">
                        <ul class="nav nav-pills" id="pills-tab" role="tablist">
                            <li class="nav-item" role="presentation">
                                <button class="nav-link active" id="pills-home-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-home" type="button" role="tab" aria-controls="pills-home"
                                    aria-selected="true"> <i class="far fa-bars"></i> <?php echo e(__('user.New Items')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-profile-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-profile" type="button" role="tab"
                                    aria-controls="pills-profile" aria-selected="false"><i class="fas fa-bolt"></i>
                                    <?php echo e(__('user.Tranding')); ?></button>
                            </li>
                            <li class="nav-item" role="presentation">
                                <button class="nav-link" id="pills-contact-tab" data-bs-toggle="pill"
                                    data-bs-target="#pills-contact" type="button" role="tab"
                                    aria-controls="pills-contact" aria-selected="false"><i class="fas fa-magic"></i>
                                    <?php echo e(__('user.Popular')); ?></button>
                            </li>
                        </ul>
                    </div>
                </div>
            </div>
            <div class="row mt_15">
                <div class="col-12">
                    <div class="tab-content" id="pills-tabContent">
                        <div class="tab-pane fade show active" id="pills-home" role="tabpanel"
                            aria-labelledby="pills-home-tab" tabindex="0">
                            <div class="row">
                                <?php $__currentLoopData = $popular_trending->new_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $new_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-xl-4 col-md-6 col-lg-4">
                                    <div class="wsus__recent_product_2_item">
                                        <div class="img">
                                            <img src="<?php echo e(custom_asset($new_product->product_icon)); ?>" alt="product" class="img-fluid w-100">
                                        </div>
                                        <div class="text">
                                            <a href="<?php echo e(route('product-detail', $new_product->slug)); ?>"><?php echo e($new_product->productlangfrontend->name); ?></a>
                                            <p>
                                                <?php if(session()->get('currency_position') == 'right'): ?>
                                                    <?php echo e($new_product->regular_price * session()->get('currency_rate')); ?><?php echo e(session()->get('currency_icon')); ?>

                                                <?php else: ?>
                                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e($new_product->regular_price * session()->get('currency_rate')); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                        <div class="tab-pane fade" id="pills-profile" role="tabpanel"
                            aria-labelledby="pills-profile-tab" tabindex="0">

                            <div class="row">
                                <?php $__currentLoopData = $popular_trending->trending_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $trending_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-xl-4 col-md-6 col-lg-4">
                                    <div class="wsus__recent_product_2_item">
                                        <div class="img">
                                            <img src="<?php echo e(custom_asset($trending_product->product_icon)); ?>" alt="product" class="img-fluid w-100">
                                        </div>
                                        <div class="text">
                                            <a href="<?php echo e(route('product-detail', $trending_product->slug)); ?>"><?php echo e($trending_product->productlangfrontend->name); ?></a>
                                            <p>
                                                <?php if(session()->get('currency_position') == 'right'): ?>
                                                    <?php echo e($trending_product->regular_price * session()->get('currency_rate')); ?><?php echo e(session()->get('currency_icon')); ?>

                                                <?php else: ?>
                                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e($trending_product->regular_price * session()->get('currency_rate')); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>

                        </div>
                        <div class="tab-pane fade" id="pills-contact" role="tabpanel"
                            aria-labelledby="pills-contact-tab" tabindex="0">
                            <div class="row">
                                <?php $__currentLoopData = $popular_trending->popular_products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $popular_product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="col-xl-4 col-md-6 col-lg-4">
                                    <div class="wsus__recent_product_2_item">
                                        <div class="img">
                                            <img src="<?php echo e(custom_asset($popular_product->product_icon)); ?>" alt="product" class="img-fluid w-100">
                                        </div>
                                        <div class="text">
                                            <a href="<?php echo e(route('product-detail', $popular_product->slug)); ?>"><?php echo e($popular_product->productlangfrontend->name); ?></a>
                                            <p>
                                                <?php if(session()->get('currency_position') == 'right'): ?>
                                                    <?php echo e($popular_product->regular_price * session()->get('currency_rate')); ?><?php echo e(session()->get('currency_icon')); ?>

                                                <?php else: ?>
                                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e($popular_product->regular_price * session()->get('currency_rate')); ?>

                                                <?php endif; ?>
                                            </p>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        RECENT PRODUCT END
    ==============================-->
    <?php endif; ?>


    <?php if($featured_section->visibility): ?>
    <!--=============================
        GALLERY 2 START
    ==============================-->
    <section class="wsus__galley_2 mt_120 xs_mt_80 pt_115 xs_pt_75 pb_120 xs_pb_80"
        style="background: url(<?php echo e(asset('frontend/images/gallery_bg.jpg')); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 col-lg-8">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e($featured_section->title); ?></h5>
                        <h2><?php echo e($featured_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php $__currentLoopData = $featured_section->products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-4 col-md-6">
                    <div class="wsus__gallery_item">
                        <div class="wsus__gallery_item_img">
                            <img src="<?php echo e(custom_asset($product->thumbnail_image)); ?>" alt="gallery" class="img-fluid w-100">
                            <ul class="wsus__gallery_item_overlay">
                                <li><a target="__blank" href="<?php echo e($product->preview_link); ?>"><?php echo e(__('user.Preview')); ?></a></li>
                                <li><a href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(__('user.Buy Now')); ?></a></li>
                            </ul>
                        </div>
                        <div class="wsus__gallery_item_text">
                            <?php
                                $review=App\Models\Review::where(['product_id' => $product->id, 'status' => 1])->get()->average('rating');
                                $sale=App\Models\OrderItem::where(['product_id' => $product->id])->get()->count();
                            ?>

                            <a class="title" href="<?php echo e(route('product-detail', $product->slug)); ?>"><?php echo e(html_decode($product->productlangfrontend->name)); ?></a>

                            <p class="category"><?php echo e(__('user.By')); ?> <span><?php echo e(html_decode($product->author->name)); ?></span> <?php echo e(__('user.In')); ?> <a class="category"
                                    href="<?php echo e(route('products', ['category' => $product->category->slug])); ?>"><?php echo e($product->category->catlangfrontend->name); ?></a></p>

                            <p class="rating">
                                <?php for($i = 1; $i <= 5; $i++): ?>
                                    <?php if($i <= $review): ?>
                                    <i class="fas fa-star"></i>
                                    <?php else: ?>
                                    <i class="far fa-star"></i>
                                    <?php endif; ?>
                                <?php endfor; ?>
                                <span>(<?php echo e($review == 0 ? 0 : $review); ?>)</span>
                            </p>
                            <p class="price">
                                <?php if(session()->get('currency_position') == 'right'): ?>
                                    <?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?><?php echo e(session()->get('currency_icon')); ?>

                                <?php else: ?>
                                    <?php echo e(session()->get('currency_icon')); ?><?php echo e(html_decode($product->regular_price * session()->get('currency_rate'))); ?>

                                <?php endif; ?>
                            </p>

                            <div class="like_and_sell">
                                <span class="download"><i class="fas fa-arrow-to-bottom"></i><?php echo e($sale); ?> <?php echo e(__('user.Sale')); ?></span>
                            </div>

                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
            <a href="<?php echo e(route('products', ['featured' => 1])); ?>" class="common_btn"><?php echo e(__('user.View All')); ?> <i class="far fa-long-arrow-right"></i></a>
        </div>
    </section>
    <!--=============================
        GALLERY 2 END
    ==============================-->
    <?php endif; ?>


    <?php if($why_choose_us->visibility): ?>
    <!--=============================
        WHU CHOOSE START
    ==============================-->
    <section class="wsus__why_choose pt_115 xs_pt_75 pb_120 xs_pb_80"
        style="background: url(<?php echo e(custom_asset($why_choose_us->background_image)); ?>);">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="wsus__section_heading mb_25">
                        <h5><?php echo e($why_choose_us->title1); ?></h5>
                        <h2><?php echo e($why_choose_us->title2); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row justify-content-between">
                <div class="col-xl-3 col-md-4">
                    <div class="wsus__why_choose_item">
                        <div class="img">
                            <img src="<?php echo e(custom_asset($why_choose_us->icon1)); ?>" alt="why choose" class="img-fluid w-100">
                        </div>
                        <h4><?php echo e($why_choose_us->item_title1); ?></h4>
                    </div>
                </div>
                <div class="col-xl-3 col-md-4">
                    <div class="wsus__why_choose_item center">
                        <div class="img">
                            <img src="<?php echo e(custom_asset($why_choose_us->icon2)); ?>" alt="why choose" class="img-fluid w-100">
                        </div>
                        <h4><?php echo e($why_choose_us->item_title2); ?></h4>
                    </div>
                </div>
                <div class="col-xl-3 col-md-4">
                    <div class="wsus__why_choose_item last">
                        <div class="img">
                            <img src="<?php echo e(custom_asset($why_choose_us->icon3)); ?>" alt="why choose" class="img-fluid w-100">
                        </div>
                        <h4><?php echo e($why_choose_us->item_title3); ?></h4>
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
       WHU CHOOSE END
    ==============================-->
    <?php endif; ?>


    <?php if($testimonial_section->visibility): ?>
    <!--=============================
        TESTIMOMNIAL START
    ==============================-->
    <section class="wsus__testimonial pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="wsus__section_heading mb_15">
                        <h5><?php echo e($testimonial_section->title); ?></h5>
                        <h2><?php echo e($testimonial_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row testi_slider">
                <?php $__currentLoopData = $testimonial_section->testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-xl-6">
                    <div class="wsus__testimonial_item">
                        <p class="rating">
                            <?php for($i = 1; $i <= 5; $i++): ?>
                                <?php if($i <= $testimonial->rating): ?>
                                <i class="fas fa-star"></i>
                                <?php else: ?>
                                <i class="far fa-star"></i>
                                <?php endif; ?>
                            <?php endfor; ?>
                        </p>
                        <p class="description"><?php echo e($testimonial->testimoniallangfrontend->comment); ?></p>
                        <div class="wsus__testimonial_footer d-flex flex-wrap">
                            <div class="img">
                                <img src="<?php echo e(custom_asset($testimonial->image)); ?>" alt="testimonial" class="img-fluid w-100">
                            </div>
                            <div class="text">
                                <h4><?php echo e($testimonial->testimoniallangfrontend->name); ?></h4>
                                <p><?php echo e($testimonial->testimoniallangfrontend->designation); ?></p>
                            </div>
                        </div>
                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!--=============================
        TESTIMOMNIAL END
    ==============================-->
    <?php endif; ?>


    <?php if($mobile_app->visibility): ?>
    <!--=============================
        DOWNLOAD START
    ==============================-->
    <section class="wsus__download pt_110 xs_pt_70" style="background: url(<?php echo e(custom_asset($mobile_app->home2_background)); ?>);">
        <div class="container">
            <div class="row justify-content-between">
                <div class="col-xl-6 col-lg-7">
                    <div class="wsus__download_text">
                        <h2><?php echo e($mobile_app->home2_title); ?></h2>
                        <p><?php echo e($mobile_app->home2_description); ?></p>
                        <ul class="d-flex flex-wrap">
                            <li>
                                <a target="_blank" href="<?php echo e($mobile_app->play_store_link); ?>">
                                    <img src="<?php echo e(asset('frontend/images/download_icon_2.png')); ?>" alt="Play store">
                                </a>
                            </li>
                            <li>
                                <a target="_blank" href="<?php echo e($mobile_app->apple_store_link); ?>">
                                    <img src="<?php echo e(asset('frontend/images/download_icon_1.png')); ?>" alt="Apple store">
                                </a>
                            </li>
                        </ul>
                    </div>
                </div>
                <div class="col-xl-5 col-lg-5">
                    <div class="wsus__download_img">
                        <img src="<?php echo e(custom_asset($mobile_app->home2_foreground)); ?>" alt="download" class="img-fluid w-100">
                    </div>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        DOWNLOAD END
    ==============================-->
    <?php endif; ?>


    <?php if($home2_blog_section->visibility): ?>
    <!--=============================
        BLOG START
    ==============================-->
    <section class="wsus__blog pt_115 xs_pt_75 pb_120 xs_pb_80">
        <div class="container">
            <div class="row">
                <div class="col-xl-7 m-auto">
                    <div class="wsus__section_heading mb_20">
                        <h5><?php echo e($home2_blog_section->title); ?></h5>
                        <h2><?php echo e($home2_blog_section->description); ?></h2>
                    </div>
                </div>
            </div>
            <div class="row">
                <?php if($home2_blog_section->blog): ?>
                <div class="col-xl-6 col-md-12 col-lg-6">
                    <div class="wsus__blog_1">
                        <div class="wsus__blog_1_img">
                            <img src="<?php echo e(custom_asset($home2_blog_section->blog->image)); ?>" alt="blog" class="img-fluid w-100">
                        </div>
                        <div class="wsus__blog_1_text">
                            <ul class="d-flex flex-wrap">
                                <li>
                                    <i class="far fa-user"></i>
                                    <?php echo e(__('user.By')); ?> <?php echo e($home2_blog_section->blog->admin->name); ?>

                                </li>
                                <li>
                                    <i class="far fa-calendar-alt"></i>
                                    <?php echo e(\Carbon\Carbon::parse($home2_blog_section->blog->created_at)->format('d M Y')); ?>

                                </li>
                            </ul>
                            <a href="<?php echo e(route('blog', $home2_blog_section->blog->slug)); ?>"><?php echo e($home2_blog_section->blog->bloglanguagefrontend->title); ?></a>
                        </div>
                    </div>
                </div>
                <?php endif; ?>
                <div class="col-xl-6 col-md-12 col-lg-6">
                    <?php $__currentLoopData = $home2_blog_section->blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $blog): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="wsus__blog_2">
                        <div class="row">
                            <div class="col-xl-5 col-md-6">
                                <div class="wsus__blog_2_img">
                                    <img src="<?php echo e(custom_asset($blog->image)); ?>" alt="blog" class="img-fluid w-100">
                                </div>
                            </div>
                            <div class="col-xl-7 col-md-6">
                                <div class="wsus__blog_2_text">
                                    <a href="<?php echo e(route('blog', $blog->slug)); ?>"><?php echo e($blog->bloglanguagefrontend->title); ?></a>
                                    <ul class="d-flex flex-wrap">
                                        <li>
                                            <i class="far fa-user"></i>
                                            <?php echo e(__('user.By')); ?> <?php echo e($blog->admin->name); ?>

                                        </li>
                                        <li>
                                            <i class="far fa-calendar-alt"></i>
                                            <?php echo e(\Carbon\Carbon::parse($blog->created_at)->format('d M Y')); ?>

                                        </li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>
        </div>
    </section>
    <!--=============================
        BLOG END
    ==============================-->
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layout2', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home2/softc/desgital.websolutionltd.com/resources/views/index2.blade.php ENDPATH**/ ?>